/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import com.illusivesoulworks.constructsarmory.ConstructsArmoryMod;
import com.james.tinkerscalibration.Utils;
import com.james.tinkerscalibration.effect.BloodThirstyArmorEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import slimeknights.tconstruct.library.modifiers.impl.TotalArmorLevelModifier;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;

public class ArmorBloodThirstyModifier
extends TotalArmorLevelModifier {
    private static final TinkerDataCapability.TinkerDataKey<Integer> BLOOD = ConstructsArmoryMod.createKey((String)"bloodthirsty_armor");

    public ArmorBloodThirstyModifier() {
        super(BLOOD);
        MinecraftForge.EVENT_BUS.addListener(ArmorBloodThirstyModifier::onHurt);
    }

    private static void onHurt(LivingHurtEvent event) {
        LivingEntity living = event.getEntityLiving();
        living.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(holder -> {
            int levels = (Integer)holder.get(BLOOD, (Object)0);
            if (levels > 0 && event.getAmount() > 0.0f) {
                int effectLevel = Math.min(7, ((BloodThirstyArmorEffect)((Object)((Object)Utils.bloodArmorEffect.get()))).getLevel(living) + 1);
                ((BloodThirstyArmorEffect)((Object)((Object)Utils.bloodArmorEffect.get()))).apply(living, 100, effectLevel, true);
            }
        });
    }
}

